<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyBookRequest;
use App\Http\Requests\StoreBookRequest;
use App\Http\Requests\UpdateBookRequest;
use App\Author;
use App\Book;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class BooksController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('book_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $books = Book::with(['authors'])->get();

        return view('admin.books.index', compact('books'));
    }

    public function create()
    {
        abort_if(Gate::denies('book_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $authors = Author::pluck('name', 'id');

        return view('admin.books.create', compact('authors'));
    }

    public function store(StoreBookRequest $request)
    {
        $authors = [];
        $authors = $request->input('authors', []);
      if ($request->input('names')!=null){
          foreach ($request->input('names') as $key => $name) {
              // Check if an author with the same name and email already exists
              $existingAuthor = Author::where('email', $request->input('emails')[$key])
                  ->first();
              if ($existingAuthor) {
                  // Use the existing author's ID
                  $authors[] = $existingAuthor->id;
              } else {
                  // Create a new author
                  $author = Author::create([
                      'name' => $name,
                      'email' => $request->input('emails')[$key],
                      'is_active' => 1,
                  ]);
                  $authors[] = $author->id;
              }
          }
      }
        $book = Book::create($request->all());
        $book->authors()->sync($authors);

        return redirect()->route('admin.books.index');
    }

    public function edit(Book $book)
    {
        abort_if(Gate::denies('book_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $authors = Author::pluck('name', 'id');

        $book->load('authors');

        return view('admin.books.edit', compact('authors', 'book'));
    }

    public function update(UpdateBookRequest $request, Book $book)
    {

        $authors = [];
        $authorIds = $request->input('ids', []);

        $serialValues = $request->input('serial', []);

        $authors = $request->input('authors', []);

        if ($request->input('names')!=null){
            foreach ($request->input('names') as $key => $name) {
                // Check if an author with the same name and email already exists
                $existingAuthor = Author::where('email', $request->input('emails')[$key])
                    ->first();
                if ($existingAuthor) {
                    // Use the existing author's ID
                    $authors[] = $existingAuthor->id;
                } else {
                    // Create a new author
                    $author = Author::create([
                        'name' => $name,
                        'email' => $request->input('emails')[$key],
                        'is_active' => 1,
                    ]);
                    $authors[] = $author->id;
                }
            }
        }

        $book->update($request->all());
        $authorsData = [];
        for ($i = 0; $i < count($authorIds); $i++) {
            $authorsData[$authorIds[$i]] = ['serial' => $serialValues[$i]];
        }
         $book->authors()->sync($authorsData);
      
           $book->authors()->sync($authors);
       

        return redirect()->route('admin.books.index');
    }

    public function show(Book $book)
    {
        abort_if(Gate::denies('book_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $book->load('authors');

        return view('admin.books.show', compact('book'));
    }

    public function destroy(Book $book)
    {
        abort_if(Gate::denies('book_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $book->delete();

        return back();
    }

    public function massDestroy(MassDestroyBookRequest $request)
    {
        $books = Book::find(request('ids'));

        foreach ($books as $book) {
            $book->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
