<?php

namespace App\Http\Controllers;

use App\Author;
use App\Book;
use App\Setting;
use App\Speaker;
use App\Schedule;
use App\SponsorType;
use App\Venue;
use App\Hotel;
use App\Gallery;
use App\Sponsor;
use App\Faq;
use App\Price;
use App\Amenity;
use App\SpeakerCategory;
class HomeController extends Controller
{
    public function index()
    {
        $settings = Setting::pluck('value', 'key');
        $speakers = Speaker::where('is_active','1')->get();
     
        $speaker_cagories = SpeakerCategory::where('is_active','1')->get();
    
        $schedules = Schedule::with('speaker')
            ->orderBy('start_time', 'asc')
            ->get()
            ->groupBy('day_number');
        $venues = Venue::all();
        $hotels = Hotel::all();
        $galleries = Gallery::all();
        $sponsors = Sponsor::all();
        $sponsor_types = SponsorType::where('is_active','1')->get();
        $faqs = Faq::all();
        $prices = Price::with('amenities')->get();
        $amenities = Amenity::with('prices')->get();
        $books = Book::with('authors')->where('is_active','1')->get();

        return view('home', compact('speaker_cagories','settings', 'speakers', 'schedules', 'venues', 'hotels', 'galleries', 'sponsors', 'faqs', 'prices', 'amenities','books','sponsor_types'));
    }

    public function view(Speaker $speaker)
    {
        $settings = Setting::pluck('value', 'key');

        return view('speaker', compact('settings', 'speaker'));
    }

    public function committee()
    {
        $settings = Setting::pluck('value', 'key');

        return view('committee2', compact('settings'));
    }
    public function callForPaper()
    {
        $settings = Setting::pluck('value', 'key');

        return view('call-for-paper', compact('settings'));
    }

}
