@extends('layouts.admin')
@section('content')

    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }} {{ trans('cruds.book.title_singular') }}
        </div>

        <div class="card-body">
            <form method="POST" action="{{ route("admin.books.store") }}" enctype="multipart/form-data">
                @csrf
                <div class="form-group">
                    <label class="required" for="title">{{ trans('cruds.book.fields.title') }}</label>
                    <textarea class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" name="title" id="title" required>{{ old('title') }}</textarea>
                    @if($errors->has('title'))
                        <span class="text-danger">{{ $errors->first('title') }}</span>
                    @endif
                    <span class="help-block">{{ trans('cruds.book.fields.title_helper') }}</span>
                </div>
                <div class="form-group">
                    <label class="required">{{ trans('cruds.book.fields.is_active') }}</label>
                    <select class="form-control {{ $errors->has('is_active') ? 'is-invalid' : '' }}" name="is_active" id="is_active" required>
                        <option value disabled {{ old('is_active', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                        @foreach(App\Book::IS_ACTIVE_SELECT as $key => $label)
                            <option value="{{ $key }}" {{ old('is_active', '1') === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                    @if($errors->has('is_active'))
                        <span class="text-danger">{{ $errors->first('is_active') }}</span>
                    @endif
                    <span class="help-block">{{ trans('cruds.book.fields.is_active_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="authors">{{ trans('cruds.book.fields.author') }}</label>
                    <div style="padding-bottom: 4px">
                        <span class="btn btn-info btn-xs select-all" style="border-radius: 0">{{ trans('global.select_all') }}</span>
                        <span class="btn btn-info btn-xs deselect-all" style="border-radius: 0">{{ trans('global.deselect_all') }}</span>
                    </div>
                    <select class="form-control select2 {{ $errors->has('authors') ? 'is-invalid' : '' }}" name="authors[]" id="authors" multiple>
                        @foreach($authors as $id => $author)
                            <option value="{{ $id }}" {{ in_array($id, old('authors', [])) ? 'selected' : '' }}>{{ $author }}</option>
                        @endforeach
                    </select>
                    @if($errors->has('authors'))
                        <span class="text-danger">{{ $errors->first('authors') }}</span>
                    @endif
                    <span class="help-block">{{ trans('cruds.book.fields.author_helper') }}</span>
                </div>


                <div id="author-container">

                </div>
                <div class="form-group">
{{--                    <button type="button" class="btn btn-success" onclick="newAuthor()">Add New Author+</button>--}}
                    <button type="button" class="btn btn-success" onclick="addAuthor()">+</button>
                </div>

                <div class="form-group">
                    <button class="btn btn-danger" type="submit">
                        {{ trans('global.save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>



@endsection

@push('script')
    <script>
        function addAuthor() {
            const authorsContainer = document.getElementById('author-container');
            const newBenefit = document.createElement('div');
            newBenefit.className = 'new_author';
            newBenefit.innerHTML = `<div class="form-group row">
<div class="col-md-5">
 <label>Name:</label>
        <input type="text" name="names[]" placeholder="Name" class="form-control extra-input required">
</div>
<div class="col-md-5">
 <label>Email:</label>
        <input type="text" name="emails[]" placeholder="Email" class="form-control extra-input email-field required">
</div>
</div>
<button type="button" class="btn btn-danger extra-input " onclick="removeAuthor(this)">-</button>`;
            authorsContainer.appendChild(newBenefit);
        }
        function removeAuthor(button) {
            const authorContainer = button.parentElement;
            const authorsContainer = document.getElementById('author-container');
            authorsContainer.removeChild(authorContainer);
        }
    </script>
@endpush


@push('style')
    <style>
        .tool,
        .benefit {
            margin-bottom: 10px;
        }
        .extra-input{
            margin: 5px 0px;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
            color:#000000!important;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice{
            color:#000000!important;
        }
    </style>
@endpush
