@extends('layouts.admin')
@section('content')

    <div class="card">
        <div class="card-header">
            {{ trans('global.edit') }} {{ trans('cruds.book.title_singular') }}
        </div>

        <div class="card-body">
            <form method="POST" action="{{ route("admin.books.update", [$book->id]) }}" enctype="multipart/form-data">
                @method('PUT')
                @csrf
                <div class="form-group">
                    <label class="required" for="title">{{ trans('cruds.book.fields.title') }}</label>
                    <textarea class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" name="title" id="title" required>{{ old('title', $book->title) }}</textarea>
                    @if($errors->has('title'))
                        <span class="text-danger">{{ $errors->first('title') }}</span>
                    @endif
                    <span class="help-block">{{ trans('cruds.book.fields.title_helper') }}</span>
                </div>
                <div class="form-group">
                    <label class="required">{{ trans('cruds.book.fields.is_active') }}</label>
                    <select class="form-control {{ $errors->has('is_active') ? 'is-invalid' : '' }}" name="is_active" id="is_active" required>
                        <option value disabled {{ old('is_active', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                        @foreach(App\Book::IS_ACTIVE_SELECT as $key => $label)
                            <option value="{{ $key }}" {{ old('is_active', $book->is_active) === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                    @if($errors->has('is_active'))
                        <span class="text-danger">{{ $errors->first('is_active') }}</span>
                    @endif
                    <span class="help-block">{{ trans('cruds.book.fields.is_active_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="authors">{{ trans('cruds.book.fields.author') }}</label>
                    <div style="padding-bottom: 4px">
                        <span class="btn btn-info btn-xs select-all" style="border-radius: 0">{{ trans('global.select_all') }}</span>
                        <span class="btn btn-info btn-xs deselect-all" style="border-radius: 0">{{ trans('global.deselect_all') }}</span>
                    </div>
                    <select class="form-control select2 {{ $errors->has('authors') ? 'is-invalid' : '' }}" name="authors[]" id="authors" multiple>
                        @foreach($authors as $id => $author)
                            <option value="{{ $id }}" {{ (in_array($id, old('authors', [])) || $book->authors->contains($id)) ? 'selected' : '' }}>{{ $author }}</option>
                        @endforeach
                    </select>
                    @if($errors->has('authors'))
                        <span class="text-danger">{{ $errors->first('authors') }}</span>
                    @endif
                    <span class="help-block">{{ trans('cruds.book.fields.author_helper') }}</span>
                </div>
                <div id="author-container">
@if(count($authors)>0)
@foreach($book->authors as $key=>$author)
<div class="form-group row">
    <div class="col-md-5">
        <label class="required">Name:</label>
        <input type="hidden" name="ids[]" value="{{ old('id', $author->id) }}">
        <input type="text" name="names1[]" required placeholder="Name" disabled value="{{ old('title', $author->name) }}" class="form-control extra-input ">
    </div>
    <div class="col-md-5">
        <label class="required">Email:</label>
        <input type="text" name="emails1[]" placeholder="Email" disabled required value="{{ old('title', $author->email) }}" class=" form-control extra-input email-field">
    </div>
    <div class="col-md-1">
        <label class="required">Serial:</label>
        <input type="number" name="serial[]" placeholder="Serial" value="{{ old('title', $author->pivot->serial) }}" required class=" form-control extra-input email-field">
    </div>
</div>
                        @endforeach
@endif

                </div>
                <div class="form-group">
                    {{--                    <button type="button" class="btn btn-success" onclick="newAuthor()">Add New Author+</button>--}}
                    <button type="button" class="btn btn-success" onclick="addAuthor()">+</button>
                </div>

                <div class="form-group">
                    <button class="btn btn-danger" type="submit">
                        {{ trans('global.save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>



@endsection

@push('script')
    <script>
        function addAuthor() {
            const authorsContainer = document.getElementById('author-container');
            const newBenefit = document.createElement('div');
            newBenefit.className = 'new_author';
            newBenefit.innerHTML = `<div class="form-group row">
<div class="col-md-5">
 <label class="required">Name:</label>
        <input type="text" name="names[]" required placeholder="Name" class="form-control extra-input ">
</div>
<div class="col-md-5">
 <label class="required">Email:</label>
        <input type="text" name="emails[]" placeholder="Email" required class=" form-control extra-input email-field">
</div>
<div class="col-md-1">
 <label class="required">Serial:<label>
         <input type="number" name="serial[]" placeholder="Serial" required class=" form-control extra-input email-field">
</div>
</div>
<button type="button" class="btn btn-danger extra-input " onclick="removeAuthor(this)">-</button>`;
            authorsContainer.appendChild(newBenefit);
        }
        function removeAuthor(button) {
            const authorContainer = button.parentElement;
            const authorsContainer = document.getElementById('author-container');
            authorsContainer.removeChild(authorContainer);
        }
    </script>
@endpush


@push('style')
    <style>
        .tool,
        .benefit {
            margin-bottom: 10px;
        }
        .extra-input{
            margin: 5px 0px;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
            color:#000000!important;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice{
            color:#000000!important;
        }
    </style>
@endpush
