<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.create')); ?> <?php echo e(trans('cruds.speaker.title_singular')); ?>

    </div>

    <div class="card-body">
        <form action="<?php echo e(route("admin.speakers.store")); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="form-group <?php echo e($errors->has('name') ? 'has-error' : ''); ?>">
                <label for="name"><?php echo e(trans('cruds.speaker.fields.name')); ?>*</label>
                <input type="text" id="name" name="name" class="form-control" value="<?php echo e(old('name', isset($speaker) ? $speaker->name : '')); ?>" required>
                <?php if($errors->has('name')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('name')); ?>

                    </p>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('cruds.speaker.fields.name_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('description') ? 'has-error' : ''); ?>">
                <label for="description"><?php echo e(trans('cruds.speaker.fields.description')); ?></label>
                <textarea id="description" name="description" class="form-control "><?php echo e(old('description', isset($speaker) ? $speaker->description : '')); ?></textarea>
                <?php if($errors->has('description')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('description')); ?>

                    </p>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('cruds.speaker.fields.description_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('full_description') ? 'has-error' : ''); ?>">
                <label for="full_description"><?php echo e(trans('cruds.speaker.fields.full_description')); ?></label>
                <textarea id="full_description" name="full_description" class="form-control "><?php echo e(old('full_description', isset($speaker) ? $speaker->full_description : '')); ?></textarea>
                <?php if($errors->has('full_description')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('full_description')); ?>

                    </p>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('cruds.speaker.fields.full_description_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('photo') ? 'has-error' : ''); ?>">
                <label for="photo"><?php echo e(trans('cruds.speaker.fields.photo')); ?></label>
                <div class="needsclick dropzone" id="photo-dropzone">

                </div>
                <?php if($errors->has('photo')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('photo')); ?>

                    </p>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('cruds.speaker.fields.photo_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('twitter') ? 'has-error' : ''); ?>">
                <label for="twitter"><?php echo e(trans('cruds.speaker.fields.twitter')); ?></label>
                <input type="text" id="twitter" name="twitter" class="form-control" value="<?php echo e(old('twitter', isset($speaker) ? $speaker->twitter : '')); ?>">
                <?php if($errors->has('twitter')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('twitter')); ?>

                    </p>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('cruds.speaker.fields.twitter_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('facebook') ? 'has-error' : ''); ?>">
                <label for="facebook"><?php echo e(trans('cruds.speaker.fields.facebook')); ?></label>
                <input type="text" id="facebook" name="facebook" class="form-control" value="<?php echo e(old('facebook', isset($speaker) ? $speaker->facebook : '')); ?>">
                <?php if($errors->has('facebook')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('facebook')); ?>

                    </p>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('cruds.speaker.fields.facebook_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('linkedin') ? 'has-error' : ''); ?>">
                <label for="linkedin"><?php echo e(trans('cruds.speaker.fields.linkedin')); ?></label>
                <input type="text" id="linkedin" name="linkedin" class="form-control" value="<?php echo e(old('linkedin', isset($speaker) ? $speaker->linkedin : '')); ?>">
                <?php if($errors->has('linkedin')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('linkedin')); ?>

                    </p>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('cruds.speaker.fields.linkedin_helper')); ?>

                </p>
            </div>

            <div class="form-group <?php echo e($errors->has('link') ? 'has-error' : ''); ?>">
                <label for="link">Serial</label>
                <input type="text" id="serial" name="serial" class="form-control" value="<?php echo e(old('serial', isset($speaker) ? $speaker->serial : '')); ?>">
                <?php if($errors->has('serial')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('serial')); ?>

                    </p>
                <?php endif; ?>
                <p class="helper-block">
                </p>
            </div>


            <div class="form-group">
                <label class="required">Speaker Category</label>
                <select class="form-control <?php echo e($errors->has('speaker_category_id') ? 'is-invalid' : ''); ?>" name="speaker_category_id" id="speaker_category_id" required>
                    <option value disabled <?php echo e(old('speaker_category_id', null) === null ? 'selected' : ''); ?>><?php echo e(trans('global.pleaseSelect')); ?></option>
                    <?php $__currentLoopData = $speaker_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php echo e(old('speaker_category_id', '') === (string) $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('speaker_category_id')): ?>
                    <span class="text-danger"><?php echo e($errors->first('speaker_category_id')); ?></span>
                <?php endif; ?>
                <span class="help-block"></span>
            </div>
            
            <div class="form-group">
                    <label class="required"><?php echo e(trans('cruds.author.fields.is_active')); ?></label>
                    <select class="form-control <?php echo e($errors->has('is_active') ? 'is-invalid' : ''); ?>" name="is_active" id="is_active" required>
                        <option value disabled <?php echo e(old('is_active', null) === null ? 'selected' : ''); ?>><?php echo e(trans('global.pleaseSelect')); ?></option>
                        <?php $__currentLoopData = App\Author::IS_ACTIVE_SELECT; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php echo e(old('is_active', '1') === (string) $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php if($errors->has('is_active')): ?>
                        <span class="text-danger"><?php echo e($errors->first('is_active')); ?></span>
                    <?php endif; ?>
                    <span class="help-block"><?php echo e(trans('cruds.author.fields.is_active_helper')); ?></span>
                </div>

            <div>
                <input class="btn btn-danger" type="submit" value="<?php echo e(trans('global.save')); ?>">
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    Dropzone.options.photoDropzone = {
    url: '<?php echo e(route('admin.speakers.storeMedia')); ?>',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    maxFiles: 1,
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').find('input[name="photo"]').remove()
      $('form').append('<input type="hidden" name="photo" value="' + response.name + '">')
    },
    removedfile: function (file) {
      file.previewElement.remove()
      if (file.status !== 'error') {
        $('form').find('input[name="photo"]').remove()
        this.options.maxFiles = this.options.maxFiles + 1
      }
    },
    init: function () {
<?php if(isset($speaker) && $speaker->photo): ?>
      var file = <?php echo json_encode($speaker->photo); ?>

          this.options.addedfile.call(this, file)
      this.options.thumbnail.call(this, file, file.url)
      file.previewElement.classList.add('dz-complete')
      $('form').append('<input type="hidden" name="photo" value="' + file.file_name + '">')
      this.options.maxFiles = this.options.maxFiles - 1
<?php endif; ?>
    },
    error: function (file, response) {
        if ($.type(response) === 'string') {
            var message = response //dropzone sends it's own error messages in string
        } else {
            var message = response.errors.file
        }
        file.previewElement.classList.add('dz-error')
        _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
        _results = []
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            node = _ref[_i]
            _results.push(node.textContent = message)
        }

        return _results
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/diutestweb1/public_html/resources/views/admin/speakers/create.blade.php ENDPATH**/ ?>